<?php
// Include database connection file
include("session.php");
include("db_vdgs.php");

// Initialize an empty array to store events
$events = array();


// Second query: Fetch events data
$sql_events = "SELECT
                    vtt_project.vtt_nameproject,
                    vtt_event.vtt_eventdate,
                    vtt_approval.vttstatus_pk,
                    vtt_status.vttstatus_name,
                    vtt_event.vtt_fulldatestart,
                     vtt_event.vtt_fulldateend
                FROM
                    vtt_event
                INNER JOIN vtt_project ON vtt_project.vttproject_pk = vtt_event.vttproject_pk
                INNER JOIN vtt_approval ON vtt_approval.vttevent_pk = vtt_event.vttevent_pk
                INNER JOIN vtt_status ON vtt_status.vttstatus_pk = vtt_approval.vttstatus_pk
                WHERE
                    vtt_event.staff_pk = ?
                AND
                    vtt_status.vttstatus_name = 'PENDING'"; // Use prepared statement to avoid SQL injection

// Prepare the query and bind parameters
$stmt_events = $db->prepare($sql_events);
$stmt_events->bind_param("i", $staff_pk);
$stmt_events->execute();
$result_events = $stmt_events->get_result();

// Fetch events and add them to $events array
while ($row_events = $result_events->fetch_assoc()) {
    // Create an event array with required fields
    $event = array(
        'title' => $row_events['vtt_nameproject'],
        'start' => $row_events['vtt_fulldatestart'],
        'end' => $row_events['vtt_fulldateend'],
        'status' => $row_events['vttstatus_name'],  // Use status name for event status
       
    );

    // Add the event array to the events array
    $events[] = $event;
}

// Close database connection
$db->close();

// Output JSON encoded array of all events
header('Content-Type: application/json');
echo json_encode($events);
?>
