<?php
// Include database connection file
include("session.php");
include("db_vdgs.php");

// Initialize an empty array to store events
$events = array();

// First query: Fetch dashboard data
$sql_dashboard = "SELECT dashboard_date, dashboard_description FROM dashboard WHERE box_no = 6";
$result_dashboard = $db->query($sql_dashboard);

// Fetch dashboard data
while ($row_dashboard = $result_dashboard->fetch_assoc()) {
    // Create an event array for dashboard
    $dashboard_event = array(
        'title' => $row_dashboard['dashboard_description'], // Use description as title
        'start' => $row_dashboard['dashboard_date'],       // Use dashboard_date as start date
        'status' => 'EVENTS',  // Default to 'PENDING' for dashboard events
       
    );
    $events[] = $dashboard_event;
}

// Second query: Fetch events data
$sql_events = "SELECT
                    vtt_project.vtt_nameproject,
                    vtt_event.vtt_eventdate,
                    vtt_approval.vttstatus_pk,
                    vtt_status.vttstatus_name,
                    vtt_event.vtt_fulldatestart,
                     vtt_event.vtt_fulldateend
                FROM
                    vtt_event
                INNER JOIN vtt_project ON vtt_project.vttproject_pk = vtt_event.vttproject_pk
                INNER JOIN vtt_approval ON vtt_approval.vttevent_pk = vtt_event.vttevent_pk
                INNER JOIN vtt_status ON vtt_status.vttstatus_pk = vtt_approval.vttstatus_pk
                WHERE
                    vtt_event.staff_pk = ?"; // Use prepared statement to avoid SQL injection

// Prepare the query and bind parameters
$stmt_events = $db->prepare($sql_events);
$stmt_events->bind_param("i", $staff_pk);
$stmt_events->execute();
$result_events = $stmt_events->get_result();

// Fetch events and add them to $events array
while ($row_events = $result_events->fetch_assoc()) {
    // Create an event array with required fields
    $event = array(
        'title' => $row_events['vtt_nameproject'],
        'start' => $row_events['vtt_fulldatestart'],
        'end' => $row_events['vtt_fulldateend'],
        'status' => $row_events['vttstatus_name'],  // Use status name for event status
       
    );

    // Add the event array to the events array
    $events[] = $event;
}

// Third query: Fetch meeting data
$sql_meeting = "SELECT
                    vtt_project.vtt_codeproject,
                    vtt_project.vtt_nameproject,
                    vtt_meeting.meeting_startdate,
                     vtt_meeting.meeting_enddate
                FROM
                    vtt_meeting
                    INNER JOIN vtt_project ON vtt_project.vttproject_pk = vtt_meeting.vttproject_pk
                    INNER JOIN staff_info ON staff_info.staff_pk = vtt_meeting.staff_pk
                WHERE
                    staff_info.staff_pk = ?";

// Prepare the query and bind parameters for meetings
$stmt_meeting = $db->prepare($sql_meeting);
$stmt_meeting->bind_param("i", $staff_pk);
$stmt_meeting->execute();
$result_meeting = $stmt_meeting->get_result();

// Fetch meetings and add them to $events array
while ($row_meeting = $result_meeting->fetch_assoc()) {
    // Create an event array with required fields
    $meeting_event = array(
        'title' => $row_meeting['vtt_codeproject'],
        'start' => $row_meeting['meeting_startdate'],
        'end' => $row_meeting['meeting_enddate'],
        'status' => "MEETING",  // Use status name for event status
        
    );

    // Add the event array to the events array
    $events[] = $meeting_event;
}

// Third query: Fetch LEAVE data
$sql_leave = "SELECT DISTINCT
                    vtt_leave.leave_code,
                    vtt_leaveevent.fullinitial_date,
                    vtt_leaveevent.fullend_date
                FROM
                    vtt_leaveevent
                INNER JOIN vtt_leave ON vtt_leave.vttleave_pk = vtt_leaveevent.vttleave_pk
                WHERE
                    vtt_leaveevent.staff_pk = ?";

// Prepare the query and bind parameters for meetings
$stmt_leave = $db->prepare($sql_leave);
$stmt_leave->bind_param("i", $staff_pk);
$stmt_leave->execute();
$result_leave = $stmt_leave->get_result();

// Fetch leaves and add them to $events array
while ($row_leave = $result_leave->fetch_assoc()) {
    // Create an event array with required fields
    $leave_event = array(
        'title' => $row_leave['leave_code'],
        'start' => $row_leave['fullinitial_date'],
        'end' => $row_leave['fullend_date'],
        'status' => "LEAVE",  // Use status name for event status
        
    );

    // Add the event array to the events array
    $events[] = $leave_event;
}

// Third query: Fetch NON-PROJECT data
$sql_nonproject = "SELECT DISTINCT
                    vtt_nonproject.nonproject_name,
                    vtt_nonprojectevent.nonproject_fullstartdate,
                    vtt_nonprojectevent.nonproject_fullenddate
                FROM
                    vtt_nonproject
                INNER JOIN vtt_nonprojectevent ON vtt_nonprojectevent.vtt_nonproject_pk = vtt_nonproject.vtt_nonproject_pk
                WHERE
                    vtt_nonprojectevent.staff_pk = ?";

// Prepare the query and bind parameters for meetings
$stmt_nonproject = $db->prepare($sql_nonproject);
$stmt_nonproject->bind_param("i", $staff_pk);
$stmt_nonproject->execute();
$result_leave = $stmt_nonproject->get_result();

// Fetch leaves and add them to $events array
while ($row_nonproject = $result_leave->fetch_assoc()) {
    // Create an event array with required fields
    $nonproject_event = array(
        'title' => $row_nonproject['nonproject_name'],
        'start' => $row_nonproject['nonproject_fullstartdate'],
        'end' => $row_nonproject['nonproject_fullenddate'],
        'status' => "NON-PROJECT",  // Use status name for event status
        
    );

    // Add the event array to the events array
    $events[] = $nonproject_event;
}


// First query: Fetch dashboard data
$sql_dashboard = "SELECT dashboard_date, dashboard_description FROM dashboard WHERE box_no = 7";
$result_dashboard = $db->query($sql_dashboard);

// Fetch dashboard data
while ($row_dashboard = $result_dashboard->fetch_assoc()) {
    // Create an event array for dashboard
    $dashboard_holiday = array(
        'title' => $row_dashboard['dashboard_description'], // Use description as title
        'start' => $row_dashboard['dashboard_date'],       // Use dashboard_date as start date
        'status' => 'PH',  // Default to 'PENDING' for dashboard events
       
    );
    $events[] = $dashboard_holiday;
}

// Close database connection
$db->close();

// Output JSON encoded array of all events
header('Content-Type: application/json');
echo json_encode($events);
?>
