<?php
// Include database connection file
include("session.php");
include("db_vdgs.php");

// Initialize an empty array to store events
$events = array();

// Third query: Fetch meeting data
$sql_meeting = "SELECT
                    vtt_project.vtt_codeproject,
                    vtt_project.vtt_nameproject,
                    vtt_meeting.meeting_startdate,
                    vtt_meeting.meeting_enddate
                FROM
                    vtt_meeting
                    INNER JOIN vtt_project ON vtt_project.vttproject_pk = vtt_meeting.vttproject_pk
                    INNER JOIN staff_info ON staff_info.staff_pk = vtt_meeting.staff_pk
                WHERE
                    staff_info.staff_pk = ?";

// Prepare the query and bind parameters for meetings
$stmt_meeting = $db->prepare($sql_meeting);
$stmt_meeting->bind_param("i", $staff_pk);
$stmt_meeting->execute();
$result_meeting = $stmt_meeting->get_result();

// Fetch meetings and add them to $events array
while ($row_meeting = $result_meeting->fetch_assoc()) {
    // Create DateTime objects for start and end dates
    $start_datetime = new DateTime($row_meeting['meeting_startdate']);
    $end_datetime = new DateTime($row_meeting['meeting_enddate']);
    
    // Format dates to match ISO 8601 format
    $start_formatted = $start_datetime->format('Y-m-d\TH:i:s');
    $end_formatted = $end_datetime->format('Y-m-d\TH:i:s');
    
    // Create an event array with required fields
    $meeting_event = array(
        'title' => $row_meeting['vtt_codeproject'],
        'start' => $start_formatted,
        'end' => $end_formatted,
        'status' => "MEETING",  // Use status name for event status
    );

    // Add the event array to the events array
    $events[] = $meeting_event;
}

// Close database connection
$db->close();

// Output JSON encoded array of all events
header('Content-Type: application/json');
echo json_encode($events);
?>
