<?php
include("db_vdgs.php");
include("session.php");

// Check if the required POST variables are set
if (isset($_POST['vtt_nonproject_pk'], $_POST['nonproject_eventdate'], $_POST['nonproject_hour'])) {
    $vtt_nonproject_pk = $_POST['vtt_nonproject_pk'];
    $nonproject_eventdate = $_POST['nonproject_eventdate'];
    $nonproject_hour = $_POST['nonproject_hour'];

    // Prepare the SQL to check existing event
    $sql_check = "-- Query for vtt_event data
                    SELECT
                        ve.vtt_timestart AS event_timestart,
                        ve.vtt_timeend AS event_timeend,
                        ve.vtt_eventdate AS event_date,
                        ve.staff_pk AS staff_no
                    FROM
                        vtt_event ve
                        INNER JOIN staff_info si ON si.staff_pk = ve.staff_pk
                    WHERE
                        ve.vtt_eventdate = '$nonproject_eventdate'
                        AND
                        ve.staff_pk = '$staff_pk'

                    UNION

                    -- Query for vtt_meeting data
                    SELECT 
                        vm.meeting_timestart AS event_timestart,        -- Meeting start time
                        vm.meeting_timeend AS event_timeend,          -- Meeting end time
                        vm.meeting_date AS event_date,              -- Meeting date
                        vm.staff_pk AS staff_no
                    FROM
                        vtt_meeting vm
                        INNER JOIN staff_info si ON si.staff_pk = vm.staff_pk
                    WHERE
                        vm.meeting_date = '$nonproject_eventdate'
                        AND
                        vm.staff_pk = '$staff_pk'


                    UNION


                    -- Query for vtt_nonprojectevent data
                    SELECT 
                        bpe.nonproject_starthour AS event_timestart,        -- vtt_nonprojectevent start time
                        bpe.nonproject_endhour AS event_timeend,          -- vtt_nonprojectevent end time
                        bpe.nonproject_eventdate AS event_date,              -- vtt_nonprojectevent date
                        bpe.staff_pk AS staff_no
                    FROM
                        vtt_nonprojectevent bpe
                        INNER JOIN staff_info si ON si.staff_pk = bpe.staff_pk
                    WHERE
                        bpe.nonproject_eventdate = '$nonproject_eventdate'
                    AND 
                        bpe.staff_pk = '$staff_pk'


                    UNION


                    SELECT
                        vl.leave_starthour AS event_timestart,
                        vl.leave_endhour AS event_timeend,
                        vle.leave_startdate AS event_date,
                        vle.staff_pk AS staff_no
                    FROM
                        vtt_leaveevent vle
                        INNER JOIN vtt_leave vl ON vl.vttleave_pk = vle.vttleave_pk
                        INNER JOIN staff_info si ON si.staff_pk = vle.staff_pk
                    WHERE
                      vle.leave_startdate = '$nonproject_eventdate'
                    AND
                      vle.staff_pk = '$staff_pk'

                    ORDER BY event_timestart
                    DESC
                    LIMIT 1
                    ";

                    $result = mysqli_query($db, $sql_check);
                        
                    $res = mysqli_fetch_array($result, MYSQLI_ASSOC);
                    {
                    //PAPARKAN NILAI ASAL	
                    $nonproject_starthour = isset($res['event_timestart']) ? $res['event_timeend'] : '9:00:00';
                    $nonproject_endhour = isset($res['event_timeend']) 
                    ? date('H:i:s', strtotime($res['event_timeend']) + ($nonproject_hour * 3600)) 
                    : date('H:i:s', strtotime($nonproject_starthour) + ($nonproject_hour * 3600)); 

                    }

                    // Combine the date and time into a single string (yyyy-mm-dd hh:mm:ss)
                    $nonproject_fullstartdate = $nonproject_eventdate . ' ' . $nonproject_starthour;
                    $nonproject_fullenddate = $nonproject_eventdate . ' ' . $nonproject_endhour;

                    // Convert the combined string into a Unix timestamp
                    $nonproject_fullstartdate = strtotime($nonproject_fullstartdate);
                    $nonproject_fullenddate = strtotime($nonproject_fullenddate);

                    // Format the timestamp into dd/mm/yy hh:mm:ss format
                    $nonproject_fullstartdate = date('y/m/d H:i:s', $nonproject_fullstartdate);
                    $nonproject_fullenddate = date('y/m/d H:i:s', $nonproject_fullenddate);

        // Start transaction
        $db->begin_transaction();

        // Insert the new event
        $sql = "INSERT INTO vtt_nonprojectevent (
                    staff_pk, vtt_nonproject_pk, nonproject_eventdate, nonproject_hour, 
                    nonproject_starthour, nonproject_endhour, nonproject_fullstartdate, nonproject_fullenddate
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

        // Prepare the insert statement
        if ($stmt = $db->prepare($sql)) {
            // Bind parameters for the insert query
            $stmt->bind_param('isssssss', $staff_pk, $vtt_nonproject_pk, $nonproject_eventdate, $nonproject_hour, 
                            $nonproject_starthour, $nonproject_endhour, $nonproject_fullstartdate, $nonproject_fullenddate);

            // Execute the query
            if ($stmt->execute()) {
                // Commit transaction
                $db->commit();
                echo "<script>alert('Registration Event Successful');
                window.location= 'calendar.php?legend_name=ALL'</script>";
            } else {
                // Rollback transaction in case of error
                $db->rollback();
                echo "<script>alert('Error: Could not register event.');
                window.location= 'calendar.php?legend_name=ALL'</script>";
            }
        }
    }

?>
