<?php
include('session.php');

// This will handle AJAX requests to fetch leave duration
if (isset($_GET['leave_type_id'])) {
    // Fetch the leave duration for the selected leave type
    $leave_type_id = $_GET['leave_type_id'];

    // Prepare SQL to fetch leave duration
    $query = "SELECT leave_duration FROM vtt_leave WHERE vttleave_pk = ?";
    $stmt = $db->prepare($query);
    $stmt->bind_param("i", $leave_type_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $response = array();
    if ($result->num_rows > 0) {
        // Fetch the leave duration
        $row = $result->fetch_assoc();
        $response['leave_duration'] = $row['leave_duration'];
    } else {
        // If no result, return a default value (or error)
        $response['leave_duration'] = 0; // Default duration if not found
    }

    // Return the response as JSON
    echo json_encode($response);
    exit(); // Stop further execution of the script after the AJAX response
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NEW NON-PROJECT FORM</title>
    <?php include('dashboard.php'); ?>
</head>
<body>
<main class="container_form">

<h4>VTT NON-PROJECT TIMESHEET</h4>

<?php $date = $_GET['date']; ?>

<a style="margin-bottom:10px" onclick="window.location.href='calendar_main.php?date=<?php echo $date ?>'" class="btn" >Back</a>

<?php   
include('project_form.php');
?>

<form action="calendar_new_nonproject_process.php" method="post">
    <table>
    <tr>
            <td><label for="vtt_nonproject_pk">Non-Project Type</label></td>
            <td>
                <select id="vtt_nonproject_pk" name="vtt_nonproject_pk">
                    <option value="">--Select Non-Project Type--</option>
                    <?php
                        // Fetch the leave options for the select dropdown
                        $non_project_option = mysqli_query($db, "SELECT vtt_nonproject_pk, nonproject_name, nonproject_code, nonproject_description FROM vtt_nonproject");
                        if ($non_project_option->num_rows > 0) {
                            $options = mysqli_fetch_all($non_project_option, MYSQLI_ASSOC);
                            foreach ($options as $option) {
                                echo "<option value='{$option['vtt_nonproject_pk']}'>{$option['nonproject_code']} - {$option['nonproject_name']}</option>";
                            }
                        }
                    ?>
                </select>
            </td>
        </tr>

        <tr>
            <td><label for="nonproject_eventdate">Selected Date</label></td>
            <td><input type="date" id="nonproject_eventdate" name="nonproject_eventdate" value="<?php echo $date;?>" required></td>
        </tr>

        <tr>
            <td><label for="nonproject_hour">Duration Hours</label></td>
            <td><input type="number" id="nonproject_hour" name="nonproject_hour" required></td>
        </tr>

        

        <tr>
            <td colspan="2">
                <input type="submit" value="Submit">
            </td>
        </tr>
    </table>
</form>

</main>
</body>
</html>
