document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth', // Default display mode
        selectable: true, // Allow date selection
        events: function(fetchInfo, successCallback, failureCallback) {
            // Fetch events dynamically from PHP script
            fetch('display_events.php')
                .then(response => response.json())
                .then(data => {
                    var events = data.map(event => ({
                        title: event.title,
                        start: event.start,
                        status: event.status // Ensure 'status' field matches what PHP script returns
                    }));

                    // Process events to assign colors based on status
                    events.forEach(event => {
                        switch (event.status) {
                            case 'PENDING':
                                event.backgroundColor = '#ADD8E6'; // Pending status color
                                break;
                            case 'APPROVED':
                                event.backgroundColor = '#90EE90'; // Approved status color
                                break;
                            case 'REJECTED':
                                event.backgroundColor = '#FF7F7F'; // Rejected status color
                                break;
                            default:
                                event.backgroundColor = '#0000FF'; // Default color
                                break;
                        }
                    });

                    successCallback(events); // Send processed events back to FullCalendar
                })
                .catch(error => {
                    console.error('Error fetching events', error);
                    failureCallback(error);
                });
        },

        dateClick: function(info) {
            var selectedDate = info.dateStr; // Selected date in YYYY-MM-DD format
            openPHPForm(selectedDate);
        },

        headerToolbar: {
            start: 'dayGridMonth,timeGridWeek,timeGridDay', // Display day, week, month buttons
            center: 'title', // Display title in the center
            end: 'today prev,next' // Display today, prev, next buttons
        },

        views: {
            timeGrid: {
                dayMaxEventRows: 10 // Adjust maximum number of events per day in timeGrid view
            }
        },

        // Handle changing views (day, week, month)
        viewDidMount: function(view) {
            // Update URL with current view type (day, week, month)
            var viewType = view.type;
            updateURL(viewType);
        }
    });

    calendar.render(); // Render the calendar

    function openPHPForm(date) {
        window.location.href = 'calendar_main.php?date=' + date;
    }

    function updateURL(viewType) {
        // Update URL based on the current view type (day, week, month)
        history.replaceState(null, null, '?view=' + viewType);
    }
});
